/*
 * SPI.h
 *
 *  Created on: Feb 12, 2016
 *      Author: B52321
 */

#ifndef SPI_H_
#define SPI_H_

#include "SPI.h"

#define MASTER 0
#define SLAVE  1

/* define SPI default values */
#define SPI_C1_DEFAULT          0x04						/*!< SPI C1 register */
#define SPI_C2_DEFAULT          0x00						/*!< SPI C2 register */
#define SPI_BR_DEFAULT          0x00						/*!< SPI BR register */
#define SPI_S_DEFAULT           0x20						/*!< SPI S register */
#define SPI_M_DEFAULT           0x00

__STATIC_INLINE uint8_t SPI_IsRxBuffFull(SPI_Type *pSPI)
{
    return (pSPI->S & SPI_S_SPRF_MASK);
}

/* Prototype */
char SPI_init(SPI_Type *pSPI, char mode);
void SPI_Reset(SPI_Type *pSPI);
void SPI_transmit(SPI_Type *pSPI, char data);
char SPI_read(SPI_Type *pSPI);
char SPI_transfer(SPI_Type *pSPI, char data);
void SPI_WaitTxComplete(SPI_Type *pSPI);

#endif /* SPI_H_ */
